
// content-script.js
// Content script for TikTok plugin - handles communication with injected script

(function () {
  function injectExternalScript() {
    try {
      const script = document.createElement('script');
      script.src = chrome.runtime.getURL('injected.js');
      script.async = false;
      (document.head || document.documentElement).appendChild(script);
      script.onload = function () {
        this.remove();
      };
      console.log('[TT Plugin] injected.js 已注入');
    } catch (e) {
      console.warn('[TT Plugin] 注入 injected.js 失败:', e);
    }
  }

  injectExternalScript();

  console.log('[TT Plugin] content-script loaded');
})();
