// content-bridge.js - Content Script 桥接插件和页面上下文的通信

// 添加立即执行的日志，确认脚本已加载
console.log('[Content Bridge] ========== Script Start ==========');
console.log('[Content Bridge] Location:', window.location.href);
console.log('[Content Bridge] Chrome runtime available:', typeof chrome !== 'undefined' && !!chrome.runtime);

// 监听来自插件（popup/sidebar/background）的消息
if (typeof chrome !== 'undefined' && chrome.runtime) {
  console.log('[Content Bridge] 开始注册消息监听器...');
  
  chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    console.log('[Content Bridge] 收到消息:', request, '来自:', sender);

    // 处理榜单数据请求
    if (request.type === 'FETCH_TOP_SELLING_DATA') {
      const { apiUrl, requestParams, requestId } = request;

      console.log('[Content Bridge] 处理 FETCH_TOP_SELLING_DATA 请求');
      console.log('[Content Bridge] API URL:', apiUrl);
      console.log('[Content Bridge] Request Params:', requestParams);

      // 创建监听器等待页面响应
      const messageHandler = (event) => {
        if (event.source !== window) return;

        // 收到页面返回的榜单数据
        if (event.data?.type === 'TT_TOP_SELLING_DATA_RESPONSE' && event.data?.requestId === requestId) {
          console.log('[Content Bridge] 收到页面返回的榜单数据:', event.data.payload);
          window.removeEventListener('message', messageHandler);
          window.removeEventListener('message', errorHandler);
          sendResponse({ success: true, data: event.data.payload });
        }
      };

      const errorHandler = (event) => {
        if (event.source !== window) return;

        // 收到页面返回的错误
        if (event.data?.type === 'TT_TOP_SELLING_DATA_ERROR' && event.data?.requestId === requestId) {
          console.error('[Content Bridge] 收到页面返回的错误:', event.data.error);
          window.removeEventListener('message', messageHandler);
          window.removeEventListener('message', errorHandler);
          sendResponse({ success: false, error: event.data.error });
        }
      };

      // 添加消息监听器
      window.addEventListener('message', messageHandler);
      window.addEventListener('message', errorHandler);

      // 设置超时(30秒)
      setTimeout(() => {
        window.removeEventListener('message', messageHandler);
        window.removeEventListener('message', errorHandler);
        console.error('[Content Bridge] 榜单请求超时，未收到 injected.js 响应');
        sendResponse({ success: false, error: '请求超时,injected.js可能未正确注入' });
      }, 30000);

      // 转发消息到页面上下文（injected.js会监听）
      console.log('[Content Bridge] 转发榜单请求到页面上下文');
      window.postMessage(
        {
          type: 'TT_FETCH_TOP_SELLING_DATA',
          apiUrl,
          requestParams,
          requestId,
        },
        '*'
      );

      // 返回true表示异步响应
      return true;
    }

    // 处理类目数据请求
    if (request.type === 'FETCH_CATEGORY_DATA') {
      const { scenario, requestId } = request;

      console.log('[Content Bridge] 处理 FETCH_CATEGORY_DATA 请求');

      // 创建监听器等待页面响应
      const messageHandler = (event) => {
        if (event.source !== window) return;

        // 收到页面返回的类目数据
        if (event.data?.type === 'TT_CATEGORY_DATA_RESPONSE' && event.data?.requestId === requestId) {
          console.log('[Content Bridge] 收到页面返回的类目数据:', event.data.payload);
          window.removeEventListener('message', messageHandler);
          window.removeEventListener('message', errorHandler);
          sendResponse({ success: true, data: event.data.payload });
        }
      };

      const errorHandler = (event) => {
        if (event.source !== window) return;

        // 收到页面返回的错误
        if (event.data?.type === 'TT_CATEGORY_DATA_ERROR' && event.data?.requestId === requestId) {
          console.error('[Content Bridge] 收到页面返回的错误:', event.data.error);
          window.removeEventListener('message', messageHandler);
          window.removeEventListener('message', errorHandler);
          sendResponse({ success: false, error: event.data.error });
        }
      };

      // 添加消息监听器
      window.addEventListener('message', messageHandler);
      window.addEventListener('message', errorHandler);

      // 设置超时
      setTimeout(() => {
        window.removeEventListener('message', messageHandler);
        window.removeEventListener('message', errorHandler);
        console.error('[Content Bridge] 请求超时，未收到 injected.js 响应');
        sendResponse({ success: false, error: '请求超时,injected.js可能未正确注入' });
      }, 12000);

      // 转发消息到页面上下文（injected.js会监听）
      console.log('[Content Bridge] 转发消息到页面上下文');
      window.postMessage(
        {
          type: 'TT_FETCH_CATEGORY_DATA',
          scenario,
          requestId,
        },
        '*'
      );

      // 返回true表示异步响应
      return true;
    }

    return false;
  });

  console.log('[Content Bridge] 消息监听器已成功注册');
} else {
  console.error('[Content Bridge] Chrome runtime 不可用!');
}

console.log('[Content Bridge] ========== Script End ==========');
